/* ***********************************************************************
   *                                                                     *
   * trigio.h                                                            *
   * Christian Zurhorst, BID R&D, 30 Jul. 1998                           *
   *                                                                     *
   * trigger IO sequencer functions                                      *
   *                                                                     *
   ***********************************************************************

*/

#ifndef __TRIGIO_H
#define __TRIGIO_H

#include <triodefs.h>


#ifdef __cplusplus
extern "C" {
#endif


CLI b_errtype EXPORT BestTrigIOSeqPropDefaultSet( /* @tiosprpdefset */
  b_handletype handle
  );

CLI b_errtype EXPORT BestTrigIOGenPropSet(            /* @tiogenprpset */
  b_handletype handle,
  b_trigioseqgenproptype trigiogenprop,               /* @prop */
  b_int32 value                                       /* @val */
  );

CLI b_errtype EXPORT BestTrigIOGenPropGet(            /* @tiogenprpget */
  b_handletype handle,
  b_trigioseqgenproptype trigiogenprop,               /* @prop */
  b_int32 *value                              	      /*  #RETURN  "property value = %d\n"*/
  );

CLI b_errtype EXPORT BestTrigIOGenPropDefaultSet(     /* @tiogenprpdefset */
  b_handletype handle
  );

CLI b_errtype EXPORT BestTrigIOSeqTranPropSet(        /* @tiostranprpset */
  b_handletype handle,
  b_int32 transient,                                  /* @tran        */
  b_trigioseqtranproptype trigioseqtranprop,          /* @prop    */
  b_int32 value                                       /* @val */
  );

CLI b_errtype EXPORT BestTrigIOSeqTranPropDefaultSet( /* @tiostranprpdefset */
  b_handletype handle,
  b_int32 transient                                   /* @tran        */
  );

CLI b_errtype EXPORT BestTrigIOSeqTranCondPropSet(    /* @tiostrancprpset */
  b_handletype handle,
  b_int32 transient,                                  /* @tran        */
  b_trigioseqtrancondproptype trigioseqtrancondprop,  /* @prop  */
  b_charptrtype condition                             /* @con */
  );

CLI b_errtype EXPORT BestTrigIOSeqProg(               /* @tiosprog */
  b_handletype handle
  );

CLI b_errtype EXPORT BestTrigIORun(                /* @tiorun */
  b_handletype handle
  );

CLI b_errtype EXPORT BestTrigIOStop(                /* @tiostop */
  b_handletype handle
  );
  


#ifdef __cplusplus
}
#endif


#endif


